/*
 * Decompiled with CFR 0.152.
 */
package com.cinemamod.mcef.internal;

import com.cinemamod.mcef.internal.MCEFDownloadListener;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class MCEFDownloaderMenu
extends Screen {
    private final Screen menu;

    public MCEFDownloaderMenu(Screen menu) {
        super((Component)Component.literal((String)"MCEF is downloading required libraries..."));
        this.menu = menu;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        double cx = (double)this.width / 2.0;
        double cy = (double)this.height / 2.0;
        double progressBarHeight = 14.0;
        double progressBarWidth = (double)this.width / 3.0;
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate(cx, cy, 0.0);
        poseStack.translate(-progressBarWidth / 2.0, -progressBarHeight / 2.0, 0.0);
        graphics.fill(0, 0, (int)progressBarWidth, (int)progressBarHeight, -1);
        graphics.fill(2, 2, (int)progressBarWidth - 2, (int)progressBarHeight - 2, -16777215);
        graphics.fill(4, 4, (int)((progressBarWidth - 4.0) * (double)MCEFDownloadListener.INSTANCE.getProgress()), (int)progressBarHeight - 4, -1);
        poseStack.popPose();
        String[] text = new String[]{MCEFDownloadListener.INSTANCE.getTask(), Math.round(MCEFDownloadListener.INSTANCE.getProgress() * 100.0f) + "%"};
        Objects.requireNonNull(this.font);
        int n = 9 / 2;
        Objects.requireNonNull(this.font);
        int oSet = n + (9 + 2) * (text.length + 2) + 4;
        poseStack.pushPose();
        poseStack.translate((float)((int)cx), (float)((int)(cy - (double)oSet)), 0.0f);
        graphics.drawString(this.font, String.valueOf(ChatFormatting.GOLD) + this.title.getString(), (int)(-((double)this.font.width(this.title.getString()) / 2.0)), 0, 0xFFFFFF);
        int index = 0;
        for (String s : text) {
            if (index == 1) {
                Objects.requireNonNull(this.font);
                poseStack.translate(0.0f, (float)(9 + 2), 0.0f);
            }
            Objects.requireNonNull(this.font);
            poseStack.translate(0.0f, (float)(9 + 2), 0.0f);
            graphics.drawString(this.font, s, (int)(-((double)this.font.width(s) / 2.0)), 0, 0xFFFFFF);
            ++index;
        }
        poseStack.popPose();
    }

    public void tick() {
        if (MCEFDownloadListener.INSTANCE.isDone() || MCEFDownloadListener.INSTANCE.isFailed()) {
            this.onClose();
            Minecraft.getInstance().setScreen(this.menu);
        }
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public boolean isPauseScreen() {
        return true;
    }
}

